<?php

namespace Allocine\DbzModelBundle\Model\Brand;

use Allocine\DbzModelBundle\Internal\Model\BrandAwareModelInterface;
use Allocine\DbzModelBundle\Internal\Model\BrandAwareModelTrait;
use Allocine\DbzModelBundle\Internal\Model\ModelTrait;
use PommProject\ModelManager\Model\Model;
use PommProject\ModelManager\Model\Projection;
use PommProject\ModelManager\Model\ModelTrait\WriteQueries;

use PommProject\Foundation\Where;

use Allocine\DbzModelBundle\Model\Brand\AutoStructure\Tag as TagStructure;
use Allocine\DbzModelBundle\Model\Brand\Tag;

/**
 * TagModel
 *
 * Model class for table tag.
 *
 * @see Model
 */
class TagModel extends Model implements BrandAwareModelInterface
{
    use WriteQueries;
    use ModelTrait;
    use BrandAwareModelTrait;

    /**
     * __construct()
     *
     * Model constructor
     *
     * @access public
     */
    public function __construct()
    {
        $this->structure = new TagStructure;
        $this->flexible_entity_class = '\Allocine\DbzModelBundle\Model\Brand\Tag';
    }
}
