<?php

namespace Allocine\DbzModelBundle\Domains;

class Tag3D
{
    private static $transformer = null;

    /**
     * Generate a valid string representation of a tag3d
     *
     * @param string $category
     * @param string|null $subCategory
     * @param string $tag
     * @return string
     */
    public static function generate(string $category, ?string $subCategory, string $tag) : string
    {
        self::generateTransformer();

        $parts = [
            $category, $subCategory, $tag
        ];

        return implode('.', array_map(self::$transformer, $parts));
    }

    private static function generateTransformer()
    {
        if(self::$transformer === null) {
            // give me https://wiki.php.net/rfc/pipe-operator plzzzz
            self::$transformer = self::compose(
                function ($x) { return $x ?? '_'; },
                function ($x) { return preg_replace("/[^A-Za-z0-9_]/", '', $x); },
                'strtolower',
                'ucfirst'
            );
        }
    }

    private static function compose(...$functions)
    {
        return array_reduce(
            $functions,
            function ($carry, $item) {
                return function ($x) use ($carry, $item) {
                    return $item($carry($x));
                };
            },
            function ($value) { return $value; }
        );
    }
}
