<?php

namespace Allocine\DbzModelBundle\Tests\Model\Social;

use Allocine\DbzModelBundle\Model\Social\UserHasRatingModel;
use Allocine\DbzModelBundle\Model\Social\UserModel;
use Allocine\DbzModelBundle\Tests\KernelTestCase;

class UserHasRatingModelTest extends KernelTestCase
{
    /**
     * @var UserHasTheaterModel
     */
    private $model;

    /**
     * Setup before
     */
    protected function setUp(): void
    {
        parent::setUp();

        $this->model = $this
            ->getSession()
            ->getModel(UserHasRatingModel::class)
        ;
    }

    /**
     *
     */
    public function testCountByUser()
    {
        $expected = [
            2000000000 => 4,
            2000000001 => 3,
            2000000002 => 0,
        ];

        foreach ($expected as $idUser => $expectedCount) {
            $user = $this->getSession()->getModel(UserModel::class)->findByPK([
                'id_brand' => 'AC',
                'id' => $idUser
            ]);

            $this->assertEquals(
                $expectedCount,
                $this->model->countByUser($user)
            );
        }
    }

}
