<?php

namespace Allocine\DbzModelBundle\Tests\Model\Social;

use Allocine\DbzModelBundle\Model\Social\UserCustomizationModel;
use Allocine\DbzModelBundle\Model\Social\UserCustomization;
use Allocine\DbzModelBundle\Tests\KernelTestCase;

class UserCustomizationModelTest extends KernelTestCase
{
     private UserCustomizationModel $model;

    /**
     * Setup before
     */
    protected function setUp(): void
    {
        parent::setUp();

        $this->model = $this
            ->getSession()
            ->getModel(UserCustomizationModel::class)
        ;
    }

    /**
     * Test finding user customization by primary key
     */
    public function testFindByPK(): void
    {
        $customization = $this->model->findByPK([
            'id_user' => 2000000000,
            'id_brand' => 'AC'
        ]);

        $this->assertInstanceOf(UserCustomization::class, $customization);
        $this->assertArrayHasKey('id_user', $customization);
        $this->assertArrayHasKey('id_brand', $customization);
    }

    /**
     * Test finding all user customizations
     */
    public function testFindAll(): void
    {
        $customizations = $this->model->findAll();

        $this->assertNotNull($customizations);

        $count = 0;
        foreach ($customizations as $customization) {
            $this->assertInstanceOf(UserCustomization::class, $customization);
            $this->assertArrayHasKey('id_user', $customization);
            $this->assertArrayHasKey('id_brand', $customization);
            $count++;
        }

        $this->assertGreaterThan(0, $count);
    }

    /**
     * Test flexible entity class
     */
    public function testFlexibleEntityClass(): void
    {
        $this->assertEquals(
            UserCustomization::class,
            $this->model->getFlexibleEntityClass()
        );
    }

    /**
     * Test structure
     */
    public function testStructure(): void
    {
        $structure = $this->model->getStructure();

        $this->assertTrue($structure->hasField('id_user'));
        $this->assertTrue($structure->hasField('id_brand'));
        $this->assertTrue($structure->hasField('id_avatar_current_image'));
        $this->assertTrue($structure->hasField('id_avatar_previous_image'));
        $this->assertTrue($structure->hasField('id_banner_current_image'));
        $this->assertTrue($structure->hasField('id_banner_previous_image'));
    }

    /**
     * Test primary keys
     */
    public function testPrimaryKeys(): void
    {
        $primaryKeys = $this->model->getStructure()->getPrimaryKey();

        $this->assertContains('id_user', $primaryKeys);
        $this->assertContains('id_brand', $primaryKeys);
        $this->assertCount(2, $primaryKeys);
    }
}
