<?php

namespace Allocine\DbzModelBundle\Model\Social;

use Allocine\DbzModelBundle\Internal\Model\BrandAwareModelInterface;
use Allocine\DbzModelBundle\Internal\Model\BrandAwareModelTrait;
use Allocine\DbzModelBundle\Internal\Model\ElementModel;
use Allocine\DbzModelBundle\Internal\Model\ModelTrait;
use Allocine\DbzModelBundle\Model\Social\AutoStructure\UserCustomization as UserCustomizationStructure;
use PommProject\ModelManager\Model\Model;

/**
 * UserCustomizationModel.
 *
 * Model class for table user_collection.
 *
 * @see Model
 */
class UserCustomizationModel extends ElementModel implements BrandAwareModelInterface
{
    use ModelTrait;
    use BrandAwareModelTrait;

    const LEGACY_SAFE = true;

    /**
     * __construct().
     *
     * Model constructor
     */
    public function __construct()
    {
        $this->structure = new UserCustomizationStructure();
        $this->flexibleEntityClass = UserCustomization::class;
    }
}
