<?php

namespace Allocine\DbzModelBundle\Model\Social;

use Allocine\DbzModelBundle\Internal\Model\BrandAwareModelInterface;
use Allocine\DbzModelBundle\Internal\Model\BrandAwareModelTrait;
use Allocine\DbzModelBundle\Internal\Model\ElementModel;
use Allocine\DbzModelBundle\Internal\Model\ModelTrait;
use Allocine\DbzModelBundle\Model\Social\AutoStructure\UserCollection as UserCollectionStructure;
use PommProject\ModelManager\Model\Model;

/**
 * UserCollectionModel.
 *
 * Model class for table user_collection.
 *
 * @see Model
 */
class UserCollectionModel extends ElementModel implements BrandAwareModelInterface
{
    use ModelTrait;
    use BrandAwareModelTrait;

    const LEGACY_SAFE = true;

    /**
     * __construct().
     *
     * Model constructor
     */
    public function __construct()
    {
        $this->structure = new UserCollectionStructure();
        $this->flexibleEntityClass = UserCollection::class;
    }

    /**
     * @param User $user
     * @return int
     */
    public function countByUser(User $user) : int
    {
        return $this->countWhere(
            'id_user = $* AND id_brand = $*',
            [
                'id_user' => $user->id,
                'id_brand' => $user->id_brand,
            ]
        );
    }
}
