<?php

namespace Allocine\DbzModelBundle\Internal\Type\Social\User\Data;

use Allocine\DbzModelBundle\Domains\Tag3D;
use Allocine\Titania\Type\Base\ObjectCollection;

class BadgeCollection extends ObjectCollection
{
    protected $internalObjectClass = Badge::class;

    /**
     * @param mixed $badge
     * @return bool
     * @throws \Exception
     */
    public function hasBadge($badge): bool
    {
        $badge = $this->normalizeBadgeTag($badge);
        $index = $this->getBadgeIndex($badge);

        return false !== $index;
    }

    /**
     * @param mixed $badge
     * @param \DateTime $createdAt
     * @return void
     * @throws \Exception
     */
    public function addBadge($badge, ?\DateTime $createdAt = null): void
    {
        $badge = $this->normalizeBadgeTag($badge);

        if (!$this->hasBadge($badge)) {
            $this->append(
                new Badge([
                    'badge' => $badge,
                    'created_at' => $createdAt ?? new \DateTime('now'),
                ])
            );
        }
    }

    /**
     * @param mixed $badge
     * @return void
     * @throws \Exception
     */
    public function removeBadge($badge): void
    {
        $badge = $this->normalizeBadgeTag($badge);
        $target = $this->getBadgeIndex($badge);

        if (false !== $target) {
            $this->offsetUnset($target);
        }
    }

    /**
     * @param Tag3D $badge
     * @return int|false
     * @throws \Exception
     */
    private function getBadgeIndex(Tag3D $badge)
    {
        foreach ($this as $index => $b) {
            /** @var Badge $b */
            if ($b->badge->isEqualTo($badge)) {
                return $index;
            }
        }

        return false;
    }

    /**
     * @param mixed $badge
     * @return Tag3D
     * @throws \Exception
     */
    private function normalizeBadgeTag($badge): Tag3D
    {
        if (is_object($badge) && $badge instanceof Tag3D) {
            return $badge;
        }

        return new Tag3D($badge);
    }
}
