<?php

namespace Allocine\DbzModelBundle\Internal\Type\Movie\MovieHasRelease;

use Allocine\DbzModelBundle\Internal\Type\Movie\MovieHasRelease\Data\Tech;
use Allocine\Titania\Type\Base\ConstrainedObject;
use Allocine\Titania\Type\Configuration\ClassDefinition;

class Data extends ConstrainedObject
{
    /**
     * @return array
     */
    public static function getAttributeDefinition()
    {
        return [
            'area' => null,
            'visa_number' => null,
            'opening_estimate' => null,
            'tech' => null,
            'advisory' => null,
        ];
    }

    /**
     * @return array
     * @throws \Exception
     */
    public static function getAttributeClassDefinition()
    {
        return [
            'tech' => new ClassDefinition([
                'class' => Tech::class,
            ]),
        ];
    }
}
