<?php

namespace Allocine\DbzModelBundle\Internal\Type\Brand\Tag\Data\Seo;

use Allocine\DbzModelBundle\Internal\Type\Brand\Tag\Data\Seo\Scope\AbstractScope;
use Allocine\Titania\Type\Base\ConstrainedObject;
use Allocine\Titania\Type\Configuration\ClassDefinition;

class Scope extends ConstrainedObject
{
    /**
     * @return array
     */
    public static function getAttributeDefinition()
    {
        return [
            'user_rating' => [],
            'press_rating' => [],
            'popularity' => [],
            'ranking' => [],
        ];
    }

    /**
     * @return array
     * @throws \Exception
     */
    public static function getAttributeClassDefinition()
    {
        return [
            'user_rating' => new ClassDefinition([
                'class' => AbstractScope::class,
            ]),
            'press_rating' => new ClassDefinition([
                'class' => AbstractScope::class,
            ]),
            'popularity' => new ClassDefinition([
                'class' => AbstractScope::class,
            ]),
            'ranking' => new ClassDefinition([
                'class' => AbstractScope::class,
            ]),
        ];
    }
}
