<?php

namespace Allocine\DbzModelBundle\Internal\Converter;

use PommProject\Foundation\Converter\ConverterInterface;
use PommProject\Foundation\Session\Session;
use Allocine\DbzModelBundle\Internal\Type\Generic\Geometry as GeometryType;

class Geometry implements ConverterInterface
{
    /**
     * @inheritdoc
     */
    public function fromPg(?string $data, string $type, Session $session): ?GeometryType
    {
        if ((trim($data) === '') || is_null($data)) {
            return null;
        }

        $result = $session->getConnection()->executeAnonymousQuery(sprintf(
            'SELECT ST_AsGeoJSon(%s::public.geometry) AS coords',
            $session->getConnection()->escapeLiteral($data)
        ));

        if (! $result) {
            return null;
        }

        $data = json_decode($result->fetchRow(0)['coords']);

        return new GeometryType([
            'type' => $data->type,
            'coordinates' => [
                'latitude' => $data->coordinates[1],
                'longitude' => $data->coordinates[0],
            ]
        ]);
    }

    /**
     * @inheritdoc
     */
    public function toPg($data, string $type, Session $session): string
    {
        return $this->toPgStandardFormat($data, $type, $session);
    }

    /**
     * @inheritdoc
     */
    public function toPgStandardFormat($data, string $type, Session $session): ?string
    {
        if ($data === null) {
            return null;
        }

        $result = $session->getConnection()->executeAnonymousQuery(sprintf(
            "SELECT ST_SetSRID(%s(%s,%s)::public.geometry, 4326) AS geometry",
            $data->type,
            $data->coordinates->longitude,
            $data->coordinates->latitude
        ));

        if (! $result) {
            return null;
        }

        return sprintf(
            "%s",
            $result->fetchRow(0)['geometry']
        );
    }
}
