<?php

namespace Allocine\DbzModelBundle\Internal\Converter;

use PommProject\Foundation\Converter\ConverterInterface;
use PommProject\Foundation\Session\Session;
use Allocine\DbzModelBundle\Internal\Type\Generic\EmptyData as EmptyDataType;

class EmptyData implements ConverterInterface
{
    /**
     * @inheritdoc
     */
    public function fromPg($emptyData, string $type, Session $session): mixed
    {
        return new EmptyDataType($emptyData);
    }

    /**
     * @inheritdoc
     */
    public function toPg($emptyData, string $type, Session $session): string
    {
        return sprintf(
            '%s::jsonb',
            $session->getConnection()->escapeLiteral($emptyData->toJson())
        );
    }

    /**
     * @inheritdoc
     */
    public function toPgStandardFormat($emptyData, string $type, Session $session): string
    {
        return sprintf(
            '%s::jsonb',
            $session->getConnection()->escapeLiteral($emptyData->toJson())
        );
    }
}
