<?php

namespace Allocine\DbzModelBundle\DependencyInjection\Compiler;

use Allocine\DbzModelBundle\DependencyInjection\ServiceHelper;
use Symfony\Component\Config\FileLocator;
use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Definition;
use Symfony\Component\DependencyInjection\Loader\PhpFileLoader;

class ModelPass implements CompilerPassInterface
{
    private $relativePathToModel = '/../../';

    public const SERVICE_PREFIX = 'dbz.model';
    public const SESSION_SERVICE_PREFIX = 'pomm.session';

    /**
     * Automatically register every models within Allocine\DbzModelBundle\Model directory as services.
     * Tagging them with pomm.model is mandatory to get the session injected.
     * Models are registered to the slave session.
     *
     * @param ContainerBuilder $container
     *
     * @throws \Exception
     */
    public function process(ContainerBuilder $container): void
    {
        $modelsLoader = new PhpFileLoader($container, new FileLocator(__DIR__.$this->relativePathToModel.'Model'));
        $definition = new Definition();

        $config = $container->getExtensionConfig('dbz_model')[0];

        if ($container->getParameter('dbz_model.force_master_backend')) {
            $sessionServiceId = ServiceHelper::findSessionNameByType($config['backends'], ServiceHelper::BACKEND_MASTER);
        } else {
            $sessionServiceId = ServiceHelper::findSessionNameByType($config['backends'], ServiceHelper::BACKEND_SLAVE);
        }

        $definition
            ->addTag('pomm.model', [
                'pooler' => 'dbz.pooler.model.slave',
                'session' => self::SESSION_SERVICE_PREFIX.'.'.$sessionServiceId,
            ])
            ->addTag(self::SERVICE_PREFIX.'.replicated')
        ;

        $modelsLoader->registerClasses(
            $definition,
            'Allocine\\DbzModelBundle\\Model\\',
            '*/*Model*'
        );
    }
}
