<?php

namespace Allocine\DbzModelBundle\DependencyInjection\Compiler;

use Allocine\DbzModelBundle\DependencyInjection\ServiceHelper;
use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;

class ModelAliasesPass implements CompilerPassInterface
{
    /**
     * Add aliases for every model services, prefixed by dbz.model (constant from ModelPass).
     * Every aliases are based on the primary defined models, therefore they are registered to the slave session.
     *
     * @param ContainerBuilder $container
     */
    public function process(ContainerBuilder $container): void
    {
        $serviceIds = $container->findTaggedServiceIds('pomm.model');

        foreach ($serviceIds as $serviceId => $serviceConfig) {
            $alias = ServiceHelper::generateAliasForModel(
                $serviceId,
                ModelPass::SERVICE_PREFIX
            );

            $container->setAlias($alias, $serviceId);
            $container->setAlias($alias.'.'.ServiceHelper::BACKEND_SLAVE, $serviceId);
        }
    }
}
