<?php

namespace Allocine\DbzModelBundle\DependencyInjection\Compiler;

use Allocine\DbzModelBundle\Command\FixturesLoadCommand;
use Allocine\DbzModelBundle\DependencyInjection\ServiceHelper;
use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Reference;

class FixtureBackendPass implements CompilerPassInterface
{
    const TAG_NAME = 'dbz.fixture_backend';

    public function process(ContainerBuilder $container): void
    {
        $fixtureCommand = $container->getDefinition(FixturesLoadCommand::class);

        // Get all pomm.model services (here we get Pomm internal model, ours are private
        // So we need to guess the service id for the master model
        foreach ($this->getTaggedServicesIds('pomm.model', $container) as $pommInnerServicesId) {
            $pommServiceClass = $container->getDefinition($pommInnerServicesId)->getClass();
            $fixtureCommand->addMethodCall('setFixtureBackends', [
                $pommServiceClass,
                new Reference(
                    ServiceHelper::generateAliasForModel(
                        $pommServiceClass,
                        'dbz.model',
                        ServiceHelper::BACKEND_MASTER
                    )
                ),
            ]);
        }

        foreach ($this->getFixtureBackends($container) as $service) {
            $fixtureCommand->addMethodCall(
                'setFixtureBackends',
                [$service, new Reference($service)]
            );
        }
    }

    private function getFixtureBackends(ContainerBuilder $container)
    {
        return $this->getTaggedServicesIds(self::TAG_NAME, $container);
    }

    private function getTaggedServicesIds($tag, ContainerBuilder $container)
    {
        return array_map(function ($service) {
            return $service;
        }, array_keys($container->findTaggedServiceIds($tag)));
    }
}
