<?php

namespace Allocine\DbzModelBundle\Tests\Domain;

use Allocine\DbzModelBundle\Domains\Tag3DMask;
use Allocine\DbzModelBundle\Tests\KernelTestCase;

class Tag3DMaskTest extends KernelTestCase
{
    public function testConstruct()
    {
        // Basic titania construct from array

        $tag = new Tag3DMask([
            'category' => '*',
            'subcategory' => 'B',
            'tag' => 'C',
        ]);

        $this->assertEquals('*', $tag->category);
        $this->assertEquals('B', $tag->subcategory);
        $this->assertEquals('C', $tag->tag);

        // Basic titania construct from object

        $tag = new Tag3DMask((object)[
            'category' => 'A',
            'subcategory' => '*',
            'tag' => 'C',
        ]);

        $this->assertEquals('A', $tag->category);
        $this->assertEquals('*', $tag->subcategory);
        $this->assertEquals('C', $tag->tag);

        // Basic titania construct from json string

        $tag = new Tag3DMask('{
            "category": "A",
            "subcategory": "B",
            "tag": "*"
        }');

        $this->assertEquals('A', $tag->category);
        $this->assertEquals('B', $tag->subcategory);
        $this->assertEquals('*', $tag->tag);

        // Invalid data

        $this->expectException('\Exception');
        $this->expectExceptionMessage(
            'Invalid $data for Allocine\DbzModelBundle\Domains\Tag3DMask constructor'
        );

        new Tag3DMask(2);
    }

    public function testToString()
    {
        $tag = new Tag3DMask('A', 'B', '*');

        $this->assertEquals('A.B.*', $tag->__toString());
    }

    public function testToLtreeString()
    {
        $tag = new Tag3DMask('*', 'B', 'C');

        $this->assertEquals([ '*', 'B', 'C' ], $tag->toLtreeArray());
    }
}
