<?php

namespace Allocine\DbzModelBundle\Model\Social;

use Allocine\DbzModelBundle\Internal\Model\BrandAwareModelInterface;
use Allocine\DbzModelBundle\Internal\Model\BrandAwareModelTrait;
use Allocine\DbzModelBundle\Internal\Model\ElementModel;
use Allocine\DbzModelBundle\Internal\Model\ModelTrait;
use Allocine\DbzModelBundle\Model\Social\AutoStructure\UserFollowUser as UserFollowUserStructure;
use PommProject\ModelManager\Model\Model;

/**
 * UserFollowUserModel.
 *
 * Model class for table user_follow_user.
 *
 * @see Model
 */
class UserFollowUserModel extends ElementModel implements BrandAwareModelInterface
{
    use ModelTrait;
    use BrandAwareModelTrait;

    const LEGACY_SAFE = true;

    /**
     * __construct().
     *
     * Model constructor
     */
    public function __construct()
    {
        $this->structure = new UserFollowUserStructure();
        $this->flexible_entity_class = UserFollowUser::class;
    }

    /**
     * @param int $followerId
     * @param int $publisherId
     * @param string $brandId
     *
     * @return \PommProject\ModelManager\Model\CollectionIterator
     */
    public function findByFollowAndPublisher(int $followerId, string $brandId, int $publisherId)
    {
        $userModel = $this
            ->getSession()
            ->getModel(UserModel::class)
        ;

        $where = Where::create('ufu.id_follower = $* AND ufu.id_brand = $* AND ufu.id_publisher = $*', [$followerId, $brandId, $publisherId]);

        $projection = $this->createProjection()
            ->setField('gid_entity', 'u.gid', 'string')
        ;

        $sql = "
            SELECT {projection}
            FROM {relation} ufu
            INNER JOIN {user} u 
              ON (u.id=ufu.id_publisher) AND (u.id_brand=ufu.id_brand)
            WHERE {where}
        ";

        $sql = strtr(
            $sql,
            [
                '{projection}' => $projection->formatFields('ufu'),
                '{relation}' => $this->structure->getRelation(),
                '{user}' => $userModel->getStructure()->getRelation(),
                '{where}' => $where,
            ]
        );

        return $this->query($sql, $where->getValues());
    }

    /**
     * @param User $user
     * @return int
     */
    public function countByPublisher(User $user) : int
    {
        return $this->countWhere(
            'id_publisher = $* AND id_brand = $*',
            [
                'id_user' => $user->id,
                'id_brand' => $user->id_brand,
            ]
        );
    }

    /**
     * @param User $user
     * @return int
     */
    public function countByFollower(User $user) : int
    {
        return $this->countWhere(
            'id_follower = $* AND id_brand = $*',
            [
                'id_user' => $user->id,
                'id_brand' => $user->id_brand,
            ]
        );
    }
}
