<?php

namespace Allocine\DbzModelBundle\Model\Brand;

use Allocine\DbzModelBundle\Internal\Model\BrandAwareModelTrait;
use Allocine\DbzModelBundle\Internal\Model\ModelTrait;
use PommProject\ModelManager\Model\Model;
use Allocine\DbzModelBundle\Model\Brand\AutoStructure\FestivalSelection as FestivalSelectionStructure;
use PommProject\ModelManager\Model\ModelTrait\ReadQueries;

/**
 * FestivalSelectionModel
 *
 * Model class for table festival_selection.
 *
 * @see Model
 */
class FestivalSelectionModel extends Model
{
    use ReadQueries;
    use ModelTrait;
    use BrandAwareModelTrait;

    /**
     * __construct()
     *
     * Model constructor
     *
     * @access public
     */
    public function __construct()
    {
        $this->structure = new FestivalSelectionStructure;
        $this->flexible_entity_class = FestivalSelection::class;
    }
}
