<?php

namespace Allocine\DbzModelBundle\Model\Brand\AutoStructure;

use PommProject\ModelManager\Model\RowStructure;

/**
 * BrandHasSeries.
 *
 * Structure class for relation brand.brand_has_series.
 *
 * Class and fields comments are inspected from table and fields comments.
 * Just add comments in your database and they will appear here.
 *
 * @see http://www.postgresql.org/docs/9.0/static/sql-comment.html
 * @see RowStructure
 */
class BrandHasSeries extends RowStructure
{
    /**
     * __construct.
     *
     * Structure definition.
     */
    public function __construct()
    {
        $this
            ->setRelation('brand.brand_has_series')
            ->setPrimaryKey(['id_series', 'id_brand'])
            ->addField('active', 'bool')
            ->addField('created_at', 'timestamp')
            ->addField('id_created_by', 'int4')
            ->addField('updated_at', 'timestamp')
            ->addField('id_updated_by', 'int4')
            ->addField('origin', 'tool.origin')
            ->addField('data', 'generic.data_with_seo')
            ->addField('id_brand', 'bpchar')
            ->addField('id_series', 'int8')
            ->addField('title', 'text')
            ->addField('synopsis', 'text')
            ->addField('synopsis_hash', 'bpchar')
            ->addField('synopsis_json', 'jsonb')
            ->addField('synopsis_short', 'text')
            ->addField('id_poster', 'int8')
            ->addField('id_cover', 'int8')
            ->addField('keywords', 'text')
        ;
    }

    /**
     * Override pg type for custom php type mapping
     *
     * @param string $name
     * @return string
     * @throws \PommProject\ModelManager\Exception\ModelException
     */
    public function getTypeFor($name)
    {
        if (in_array($name, [ 'data' ])) {
            return 'jsonb';
        }
        return parent::getTypeFor($name);
    }
}
