<?php

namespace Allocine\DbzModelBundle\Internal\Type\Brand\Company;

use Allocine\DbzModelBundle\Internal\Type\Generic\Links;
use Allocine\DbzModelBundle\Internal\Type\Executive\Company\Data as CompanyData;
use Allocine\DbzModelBundle\Internal\Type\Generic\Data\Seo;
use Allocine\Titania\Type\Base\ConstrainedObject;
use Allocine\Titania\Type\Configuration\ClassDefinition;

/**
/**
 * @property \Allocine\DbzModelBundle\Internal\Type\Executive\Company\Data\Info $info
 * @property \DateTime $founded_at
 * @property Links $links
 * @property Seo $seo
 */
class Data extends CompanyData
{
    /**
     * @return array
     */
    public static function getAttributeDefinition()
    {
        return [
            'seo' => [],
        ];
    }

    /**
     * @return array
     * @throws \Exception
     */
    public static function getAttributeClassDefinition()
    {
        return [
            'seo' => new ClassDefinition([
                'class' =>  Seo::class,
            ]),
        ];
    }

    /**
     * branded companies can't be theaters.
     *
     * @param mixed $data
     */
    public function setFromSomeData($data)
    {
        ConstrainedObject::setFromSomeData($data);
    }

    /**
     * Attributes defined in TheaterData but not present in CompanData are
     * ignored
     *
     * @param string $name
     * @param mixed $value
     * @return mixed|void
     */
    public function setAttribute($name, $value)
    {
        ConstrainedObject::setAttribute($name, $value);
    }

}
