<?php

namespace Allocine\DbzModelBundle\Tests\Model\Executive;

use Allocine\DbzModelBundle\Model\Executive\CompanyLocalizedModel;
use Allocine\DbzModelBundle\Model\Executive\CompanyModel;
use Allocine\DbzModelBundle\Tests\KernelTestCase;

class CompanyLocalizedTest extends KernelTestCase
{
    /**
     * @var CompanyLocalizedModel
     */
    private $model;

    /**
     * Setup before
     */
    protected function setUp(): void
    {
        parent::setUp();

        $this->model = $this
            ->getSession()
            ->getModel(CompanyLocalizedModel::class);
    }

    /**
     * Test non-empty data insert
     */
    public function testEmptyData()
    {
        $this->expectException('\Exception');
        $this->expectExceptionMessage(
            'Invalid attribute [coin] for constrained object [Allocine\DbzModelBundle\Internal\Type\Generic\EmptyData]'
        );

        /**
         * Creating a CompanyLocalized
         */

        $companyLocalized = $this->model->createEntity([
            'id' => 2000000000,
            'name' => 'Company Localized 1',
            'locale' => 'fr_FR',
            'data' => [ 'coin' => 'PAN' ]
        ]);

        $this->model->insertOne($companyLocalized);
    }
}
