<?php

namespace Allocine\DbzModelBundle\Model\Stats;

use Allocine\DbzModelBundle\Internal\Model\BrandAwareModelInterface;
use Allocine\DbzModelBundle\Internal\Model\BrandAwareModelTrait;
use Allocine\DbzModelBundle\Internal\Model\ModelTrait;
use PommProject\ModelManager\Model\Model;
use PommProject\ModelManager\Model\ModelTrait\WriteQueries;
use Allocine\DbzModelBundle\Model\Stats\AutoStructure\BrandSeriesSeasonDay as BrandSeriesSeasonDayStructure;

/**
 * BrandSeriesSeasonDayModel
 *
 * Model class for table brand_series_season_day.
 *
 * @see Model
 */
class BrandSeriesSeasonDayModel extends Model implements BrandAwareModelInterface
{
    use WriteQueries;
    use ModelTrait;
    use BrandAwareModelTrait;

    /**
     * __construct()
     *
     * Model constructor
     *
     * @access public
     */
    public function __construct()
    {
        $this->structure = new BrandSeriesSeasonDayStructure;
        $this->flexible_entity_class = BrandSeriesSeasonDay::class;
    }
}
