<?php

namespace Allocine\DbzModelBundle\Model\Social;

use Allocine\DbzModelBundle\Internal\Model\BrandAwareModelInterface;
use Allocine\DbzModelBundle\Internal\Model\BrandAwareModelTrait;
use Allocine\DbzModelBundle\Internal\Model\ElementModel;
use Allocine\DbzModelBundle\Internal\Model\ModelTrait;
use Allocine\DbzModelBundle\Model\Social\AutoStructure\UserHasReview as UserHasReviewStructure;
use PommProject\ModelManager\Model\Model;
use PommProject\ModelManager\Model\ModelTrait\WriteQueries;

/**
 * UserHasReviewModel.
 *
 * Model class for table user_has_review.
 *
 * @see Model
 */
class UserHasReviewModel extends ElementModel implements BrandAwareModelInterface
{
    use ModelTrait;
    use BrandAwareModelTrait;

    const LEGACY_SAFE = true;

    /**
     * __construct().
     *
     * Model constructor
     */
    public function __construct()
    {
        $this->structure = new UserHasReviewStructure();
        $this->flexible_entity_class = UserHasReview::class;
    }

    /**
     * @param User $user
     * @return int
     */
    public function countByUser(User $user) : int
    {
        return $this->countWhere(
            'id IN (
                        SELECT id
                        FROM social.user_has_rating
                        WHERE id_user = $* AND id_brand = $*
                    )',
            [
                'id_user' => $user->id,
                'id_brand' => $user->id_brand,
            ]
        );
    }

}
