<?php

namespace Allocine\DbzModelBundle\Model\Brand;

use Allocine\DbzModelBundle\Internal\Model\BrandAwareModelTrait;
use Allocine\DbzModelBundle\Internal\Model\ModelTrait;
use Allocine\DbzModelBundle\Model\Brand\AutoStructure\SeriesEpisode as SeriesEpisodeStructure;
use PommProject\ModelManager\Model\Model;
use PommProject\ModelManager\Model\ModelTrait\ReadQueries;

/**
 * SeriesEpisodeModel.
 *
 * Model class for table series_episode.
 *
 * @see Model
 */
class SeriesEpisodeModel extends Model
{
    use ReadQueries;
    use ModelTrait;
    use BrandAwareModelTrait;

    /**
     * __construct().
     *
     * Model constructor
     */
    public function __construct()
    {
        $this->structure = new SeriesEpisodeStructure();
        $this->flexible_entity_class = SeriesEpisode::class;
    }
}
