<?php

namespace Allocine\DbzModelBundle\Internal\Type\Generic;

use Allocine\DbzModelBundle\Internal\Type\Generic\Link\RouteParams;
use Allocine\Titania\Type\Base\ConstrainedObject;
use Allocine\Titania\Type\Configuration\ClassDefinition;

class Link extends ConstrainedObject
{
    /**
     * @return array
     */
    public static function getAttributeDefinition()
    {
        return [
            'url' => null,
            'route' => null,
            'route_params' => null,
            'title' => null,
            'new_window' => false,
            'obfuscate' => false,
        ];
    }

    /**
     * @return array
     * @throws \Exception
     */
    public static function getAttributeClassDefinition()
    {
        return [
            'route_params' => new ClassDefinition([
                'class' => RouteParams::class,
                'nullable' => true,
            ]),
        ];
    }
}
