<?php

namespace Allocine\DbzModelBundle\Internal\Type\Executive\Company;

use Allocine\DbzModelBundle\Internal\Type\Executive\Company\Data\Info;
use Allocine\DbzModelBundle\Internal\Type\Executive\Company\Data\Tech;
use Allocine\DbzModelBundle\Internal\Type\Generic\Links;
use Allocine\DbzModelBundle\Internal\Type\Theater\Theater\Data as TheaterData;
use Allocine\Titania\Type\Base\ConstrainedObject;
use Allocine\Titania\Type\Configuration\ClassDefinition;

/**
 * @property Info $info
 * @property \DateTime $founded_at
 * @property Links $links
 */
class Data extends ConstrainedObject
{
    /**
     * @var bool
     */
    public $isTheaterData = false;

    /**
     * @var TheaterData
     */
    private $theaterData;

    /**
     * @return array
     */
    public static function getAttributeDefinition()
    {
        return [
            'info' => [],
            'founded_at' => null,
            'links' => [],
            'tech' => [],
        ];
    }

    /**
     * @return array
     * @throws \Exception
     */
    public static function getAttributeClassDefinition()
    {
        return [
            'info' => new ClassDefinition([
                'class' => Info::class,
            ]),
            'founded_at' => new ClassDefinition([
                'class' => \DateTime::class,
                'nullable' => true,
            ]),
            'links' => new ClassDefinition([
                'class' => Links::class,
            ]),
            'tech' => new ClassDefinition([
                'class' => Tech::class,
            ]),
        ];
    }

    /**
     * Since a theater inherits from company (database-wise), company data
     * can contains fields that are not permitted.
     *
     * @param mixed $data
     */
    public function setFromSomeData($data)
    {
        $this->theaterData = new TheaterData($data);

        parent::setFromSomeData($data);
    }

    /**
     * Attributes defined in TheaterData but not present in CompanData are
     * ignored
     *
     * @param string $name
     * @param mixed $value
     * @return mixed|void
     */
    public function setAttribute($name, $value)
    {
        if (! $this->hasAttribute($name) &&
            $this->theaterData->hasAttribute($name)
        ) {
            $this->isTheaterData = true;

            return;
        }

        parent::setAttribute($name, $value);
    }
}
