<?php

namespace Allocine\DbzModelBundle\Tests\Model\Social;

use Allocine\DbzModelBundle\Model\Social\UserHasReviewModel;
use Allocine\DbzModelBundle\Model\Social\UserModel;
use Allocine\DbzModelBundle\Tests\KernelTestCase;

class UserHasReviewModelTest extends KernelTestCase
{
    /**
     * @var UserHasTheaterModel
     */
    private $model;

    /**
     * Setup before
     */
    protected function setUp(): void
    {
        parent::setUp();

        $this->model = $this
            ->getSession()
            ->getModel(UserHasReviewModel::class)
        ;
    }

    /**
     *
     */
    public function testCountByUser()
    {
        $expected = [
            2000000000 => 3,
            2000000001 => 2,
            2000000002 => 0,
        ];

        foreach ($expected as $idUser => $expectedCount) {
            $user = $this->getSession()->getModel(UserModel::class)->findByPK([
                'id_brand' => 'AC',
                'id' => $idUser
            ]);

            $this->assertEquals(
                $expectedCount,
                $this->model->countByUser($user)
            );
        }
    }

}
