<?php

namespace Allocine\DbzModelBundle\Tests\Model\Secure;

use Allocine\DbzModelBundle\Model\Secure\Application;
use Allocine\DbzModelBundle\Model\Secure\ApplicationModel;
use Allocine\DbzModelBundle\Model\Secure\Token;
use Allocine\DbzModelBundle\Model\Secure\TokenModel;
use Allocine\DbzModelBundle\Tests\KernelTestCase;

class TokenModelTest extends KernelTestCase
{
    /**
     * @todo use data-providers / fixtures
     *
     * @var array
     */
    private $tokens = [
        [
            'uuid' => 'c9864b7a-af50-4a10-a062-ed88ababb0c5',
            'tags' => '',
            'token' => 'a token string 1',
            'gid_user' => ['secure', 'user', '_', '1'],
        ],
        [
            'uuid' => '6ef8844e-4889-4dfe-a9df-cb60f0e0876c',
            'tags' => '',
            'token' => 'a token string 2',
            'gid_user' => null,
        ],
    ];

    protected function setUp(): void
    {
        parent::setUp();

        /** @var ApplicationModel $applicationModel */
        $applicationModel = $this->getSession()->getModel(ApplicationModel::class);

        /** @var Application $application */
        $application = $applicationModel->createEntity();
        $application->setName('fake_app')->setTags([]);
        $applicationModel->insertOne($application);

        foreach ($this->tokens as $token) {
            $this->getModel()->createAndSave($token);
        }
    }

    /**
     * @return TokenModel
     */
    private function getModel()
    {
        return static::getContainer()->get(TokenModel::class);
    }

    public function testFindByUuid()
    {
        $foundAll = true;
        foreach ($this->tokens as $token) {
            if (null === $this->getModel()->findByUuid($token['uuid'])) {
                $foundAll = false;
                break;
            }
        }
        $this->assertNotFalse($foundAll);

        $this->assertNull($this->getModel()->findByUuid('not-a-valid-uuid'));
    }

    public function testFindByToken()
    {
        $foundAll = true;
        foreach ($this->tokens as $token) {
            if (null === $this->getModel()->findByToken($token['token'])) {
                $foundAll = false;
                break;
            }
        }
        $this->assertNotFalse($foundAll);

        $this->assertNull($this->getModel()->findByToken('A non-existing token string.'));
    }

    public function testFindByUserId()
    {
        $this->assertInstanceOf(
            Token::class,
            $this->getModel()->findByUserId('secure.user._.1')
        );
    }
}
