<?php
namespace Allocine\DbzModelBundle\Model\DarkZone\AutoStructure;

use PommProject\ModelManager\Model\RowStructure;

/**
 * Lost
 *
 * Structure class for relation dark_zone.unmatching.
 *
 * Class and fields comments are inspected from table and fields comments.
 * Just add comments in your database and they will appear here.
 * @see http://www.postgresql.org/docs/9.0/static/sql-comment.html
 *
 * @see RowStructure
 */
class Unmatching extends RowStructure
{
    /**
     * __construct
     *
     * Structure definition.
     *
     * @access public
     */
    public function __construct()
    {
        $this
            ->setRelation('dark_zone.unmatching')
            ->setPrimaryKey(['entity_type', 'source_name', 'source_id'])
            ->addField('active', 'bool')
            ->addField('created_at', 'timestamp')
            ->addField('id_created_by', 'int4')
            ->addField('updated_at', 'timestamp')
            ->addField('id_updated_by', 'int4')
            ->addField('origin', 'tool.origin')
            ->addField('data', 'jsonb')
            ->addField('entity_type', 'ltree')
            ->addField('source_name', 'text')
            ->addField('source_id', 'text')
            ->addField('source_channel', 'text')
        ;
    }
}
