<?php

namespace Allocine\DbzModelBundle\Model\Brand\AutoStructure;

use PommProject\ModelManager\Model\RowStructure;

/**
 * Image.
 *
 * Structure class for relation brand.image.
 *
 * Class and fields comments are inspected from table and fields comments.
 * Just add comments in your database and they will appear here.
 *
 * @see http://www.postgresql.org/docs/9.0/static/sql-comment.html
 * @see RowStructure
 */
class Image extends RowStructure
{
    /**
     * __construct.
     *
     * Structure definition.
     */
    public function __construct()
    {
        $this
            ->setRelation('brand.image')
            ->setPrimaryKey(['id'])
            ->addField('active', 'bool')
            ->addField('created_at', 'timestamp')
            ->addField('updated_at', 'timestamp')
            ->addField('gid', 'public.global_id')
            ->addField('id', 'int8')
            ->addField('path', 'text')
            ->addField('title', 'text')
            ->addField('original_title', 'text')
            ->addField('description', 'text')
            ->addField('tags', 'public.tag3d_array')
        ;
    }
}
