<?php

namespace Allocine\DbzModelBundle\Model\Brand\AutoStructure;

use PommProject\ModelManager\Model\RowStructure;

/**
 * Festival
 *
 * Structure class for relation brand.festival.
 *
 * Class and fields comments are inspected from table and fields comments.
 * Just add comments in your database and they will appear here.
 * @see http://www.postgresql.org/docs/9.0/static/sql-comment.html
 *
 *
 *
 * @see RowStructure
 */
class Festival extends RowStructure
{
    /**
     * __construct
     *
     * Structure definition.
     *
     * @access public
     */
    public function __construct()
    {
        $this
            ->setRelation('brand.festival')
            ->setPrimaryKey(['id'])
            ->addField('created_at', 'timestamp')
            ->addField('id_created_by', 'int4')
            ->addField('updated_at', 'timestamp')
            ->addField('id_updated_by', 'int4')
            ->addField('active', 'bool')
            ->addField('gid', 'public.global_id')
            ->addField('id', 'int8')
            ->addField('name', 'text')
            ->addField('locale', 'text')
            ->addField('original_name', 'text')
            ->addField('synopsis', 'text')
            ->addField('data', 'jsonb')
            ->addField('id_country', 'int8')
            ->addField('weight', 'int4')
            ->addField('tags', 'public.tag3d_array')
            ->addField('id_poster', 'int8')
            ->addField('id_banner', 'int8')
            ->addField('localization_created_at', 'timestamp')
            ->addField('localization_id_created_by', 'int4')
            ->addField('localization_updated_at', 'timestamp')
            ->addField('localization_id_updated_by', 'int4')
            ;
    }
}
