<?php

namespace Allocine\DbzModelBundle\Internal\Type\Social\UserHasReview;

use Allocine\DbzModelBundle\Internal\Type\Social\UserHasReview\Stats\Metric;
use Allocine\Titania\Type\Base\ConstrainedObject;
use Allocine\Titania\Type\Configuration\ClassDefinition;

/**
 * Class Stats
 * @package Allocine\DbzModelBundle\Internal\Type\Social\UserHasReview
 *
 * @property Metric metric
 * @property Rank rank
 */
class Stats extends ConstrainedObject
{
    /**
     * @return array
     */
    public static function getAttributeDefinition()
    {
        return [
            'metric' => null,
        ];
    }

    /**
     * @return array
     * @throws \Exception
     */
    public static function getAttributeClassDefinition()
    {
        return [
            'metric' => new ClassDefinition([
                'class' => Metric::class,
                'nullable' => true
            ]),
        ];
    }
}
