<?php

namespace Allocine\DbzModelBundle\Internal\Type\Social\User\Data;

use Allocine\Titania\Type\Base\ConstrainedObject;
use Allocine\Titania\Type\Configuration\ClassDefinition;

/**
 * Class Token
 * @package Allocine\DbzModelBundle\Internal\Type\Social\User\Data
 *
 * @property string token
 * @property \DateTime created_at
 */
class Token extends ConstrainedObject
{
    /**
     * @return array
     */
    public static function getAttributeDefinition()
    {
        return [
            'token' => null,
            'created_at' => null,
        ];
    }

    /**
     * @return array
     * @throws \Exception
     */
    public static function getAttributeClassDefinition()
    {
        return [
            'created_at' => new ClassDefinition([
                'class' => \DateTime::class,
            ]),
        ];
    }
}
