<?php

namespace Allocine\DbzModelBundle\Internal\Converter\Theater;

use PommProject\Foundation\Converter\ConverterInterface;
use PommProject\Foundation\Session\Session;
use Allocine\DbzModelBundle\Internal\Type\Theater\Theater\Data as DataType;

class Data implements ConverterInterface
{
    /**
     * @inherit
     */
    public function fromPg($data, string $type, Session $session): mixed
    {
        return new DataType($data);
    }
    /**
     * @inheritdoc
     */
    public function toPg($data, string $type, Session $session): string
    {
        return sprintf(
            '%s::jsonb',
            $session->getConnection()->escapeLiteral($data->toJson())
        );
    }

    /**
     * @inheritdoc
     */
    public function toPgStandardFormat($data, string $type, Session $session): string
    {
        return sprintf(
            '%s::jsonb',
            $session->getConnection()->escapeLiteral($data->toJson())
        );
    }
}
