<?php

namespace Allocine\DbzModelBundle\Internal\Converter\Series\SeriesSeasonHasRelease;

use PommProject\Foundation\Converter\ConverterInterface;
use PommProject\Foundation\Session\Session;
use Allocine\DbzModelBundle\Internal\Type\Series\SeriesSeasonHasRelease\Data
    as DataType;

class Data implements ConverterInterface
{
    /**
     * {@inheritdoc}
     */
    public function fromPg(?string $data, string $type, Session $session): mixed
    {
        return new DataType($data);
    }

    /**
     * {@inheritdoc}
     */
    public function toPg($data, string $type, Session $session): string
    {
        return sprintf(
            '%s::jsonb',
            $session->getConnection()->escapeLiteral($data->toJson())
        );
    }

    /**
     * {@inheritdoc}
     */
    public function toPgStandardFormat($data, string $type, Session $session): string
    {
        return sprintf(
            '%s::jsonb',
            $session->getConnection()->escapeLiteral($data->toJson())
        );
    }
}
