<?php

namespace Allocine\DbzModelBundle\Internal\Converter\DarkZone\Lost;

use PommProject\Foundation\Converter\ConverterInterface;
use PommProject\Foundation\Session\Session;
use Allocine\DbzModelBundle\Internal\Type\DarkZone\Lost\MatchingData
    as MatchingDataType;

class MatchingData implements ConverterInterface
{
    /**
     * @inherit
     */
    public function fromPg($data, string $type, Session $session): mixed
    {
        return new MatchingDataType($data);
    }
    /**
     * @inheritdoc
     */
    public function toPg($data, string $type, Session $session): string
    {
        return sprintf(
            '%s::jsonb',
            $session->getConnection()->escapeLiteral($data->toJson())
        );
    }

    /**
     * @inheritdoc
     */
    public function toPgStandardFormat($data, string $type, Session $session): string
    {
        return sprintf(
            '%s::jsonb',
            $session->getConnection()->escapeLiteral($data->toJson())
        );
    }
}
