<?php

namespace Allocine\DbzModelBundle\Tests\Type\Brand\BrandHasMovie;

use Allocine\DbzModelBundle\Internal\Type\Brand\BrandHasMovie\Data;
use Allocine\DbzModelBundle\Tests\KernelTestCase;

class DataTest extends KernelTestCase
{
    public function testConstruct()
    {
        // Create a entityHasOverride data with no field

        $entityHasOverrideData = new Data('{}');

        $this->assertTrue($entityHasOverrideData->seo->browsable);
        $this->assertNull($entityHasOverrideData->seo->title);
        $this->assertNull($entityHasOverrideData->seo->alternate_title);
        $this->assertNull($entityHasOverrideData->seo->description);
        $this->assertNull($entityHasOverrideData->advice->label);
        $this->assertNull($entityHasOverrideData->advice->for_children);
        $this->assertTrue($entityHasOverrideData->ruling->has_rating);
        $this->assertFalse($entityHasOverrideData->ruling->at_risk);

        // Create a full entityHasOverride data

        $entityHasOverrideData = new Data([
            'seo' => [
                'browsable' => false,
                'title' => 'title 1',
                'alternate_title' => 'title 2',
                'description' => 'description 1',
            ],
            'advice' => [
                'label' => 'label 1',
                'for_children' => true,
            ],
            'ruling' => [
                'has_rating' => false,
                'at_risk' =>  true,
            ]
        ]);

        $this->assertFalse($entityHasOverrideData->seo->browsable);
        $this->assertEquals('title 1', $entityHasOverrideData->seo->title);
        $this->assertEquals('title 2', $entityHasOverrideData->seo->alternate_title);
        $this->assertEquals('description 1', $entityHasOverrideData->seo->description);
        $this->assertEquals('label 1', $entityHasOverrideData->advice->label);
        $this->assertTrue($entityHasOverrideData->advice->for_children);
        $this->assertFalse($entityHasOverrideData->ruling->has_rating);
        $this->assertTrue($entityHasOverrideData->ruling->at_risk);

        // Create a BrandHasMovie with an invalid field

        $this->expectException('\Exception');
        $this->expectExceptionMessage(
            'Invalid attribute [alternateTitle] for constrained object [Allocine\DbzModelBundle\Internal\Type\Generic\Data\Seo'
        );

        new Data([
            'seo' => [ 'alternateTitle' => 'PAN' ]
        ]);
    }
}
