<?php

namespace Allocine\DbzModelBundle\Tests\Model\Secure;

use Allocine\DbzModelBundle\Tests\KernelTestCase;
use Allocine\DbzModelBundle\Model\Secure\User;
use Symfony\Component\Security\Core\User\UserInterface;

class UserTest extends KernelTestCase
{
    /**
     * @dataProvider getUserFixtures
     */
    public function testRoles(array $data, array $roles): void
    {
        $this->assertSame($roles, (new User($data))->getRoles());
    }

    public function getUserFixtures(): array
    {
        return [
            [[], ['ROLE_USER']],
            [['admin' => false], ['ROLE_USER']],
            [['admin' => true], ['ROLE_USER', 'ROLE_SUPER_ADMIN']],
        ];
    }
}
