<?php

namespace Allocine\DbzModelBundle\Model\Country;

use Allocine\DbzModelBundle\Exception\NotFoundException;
use Allocine\DbzModelBundle\Internal\Model\BrandAwareModelTrait;
use Allocine\DbzModelBundle\Internal\Model\ElementModel;
use Allocine\DbzModelBundle\Internal\Model\ModelTrait;
use Allocine\DbzModelBundle\Model\Country\AutoStructure\Certificate as CertificateStructure;
use PommProject\ModelManager\Model\Model;

/**
 * CertificateModel.
 *
 * Model class for table certificate.
 *
 * @see Model
 */
class CertificateModel extends ElementModel
{
    use ModelTrait;

    /**
     * __construct().
     *
     * Model constructor
     */
    public function __construct()
    {
        $this->structure = new CertificateStructure();
        $this->flexibleEntityClass = Certificate::class;
    }

    public function findOneByLimitedLocalizationAndCodeCertificate(string $localizationId, string $countryId, string $code): Certificate
    {
        $data = $this->findWhere(
            'limited_to_id_localization = $* AND id_country = $* AND code = $*',
            [
                $localizationId,
                $countryId,
                $code,
            ]
        )->current();

        if ($data === null) {
            throw new NotFoundException(sprintf('impossible to find Certificate with %s', json_encode(['limited_to_id_localization' => $localizationId, 'id_country' => $countryId, 'code' => $code])));
        }

        return $data;
    }


}
