<?php

namespace Allocine\DbzModelBundle\Internal\Model;

use PommProject\ModelManager\Model\Projection;

trait ModelTrait
{
    /** @inheritDoc */
    public function createProjection(array $fields = []): Projection
    {
        if (empty($fields)) {
            return parent::createProjection();
        }

        $projection = new Projection($this->flexibleEntityClass);
        foreach ($fields as $name => $field) {
            $projection->setField($name, ...$field);
        }

        return $projection;
    }
}
