<?php

namespace Allocine\DbzModelBundle\Internal\Converter;

use PommProject\Foundation\Converter\ConverterInterface;
use PommProject\Foundation\Session\Session;
use Allocine\DbzModelBundle\Internal\Type\Generic\Address as AddressType;

class Address implements ConverterInterface
{
    /**
     * @inheritdoc
     */
    public function fromPg(?string $address, string $type, Session $session): mixed
    {
        return new AddressType($address);
    }

    /**
     * @inheritdoc
     */
    public function toPg($address, string $type, Session $session): string
    {
        return sprintf(
            '%s::jsonb',
            $session->getConnection()->escapeLiteral($address->toJson())
        );
    }

    /**
     * @inheritdoc
     */
    public function toPgStandardFormat($address, string $type, Session $session): ?string
    {
        return sprintf(
            '%s::jsonb',
            $session->getConnection()->escapeLiteral($address->toJson())
        );
    }
}
