<?php

namespace Allocine\DbzModelBundle\Domains;

use Allocine\Titania\Type\Base\ObjectCollection;

class Tag3DCollection extends ObjectCollection
{
    protected $internalObjectClass = Tag3D::class;

    /**
     * Construct a new array object
     */
    public function __construct(mixed $data = null)
    {
        /**
         * postgres array string '{...}' should be handled as such, and not
         * as a json string passed to the parent class
         */

        if (is_string($data) &&
            preg_match('/^\{(.*?)}$/', $data, $m)
        ) {
            if ($m[1] === '') {
                $data = null;
            } else {
                $data = explode(',', $m[1]);
            }
        }

        parent::__construct($data ?? []);
    }

    public function toStringArray(): array
    {
        return array_map(
            function (Tag3D $value) {
                return $value->__toString();
            },
            $this->toArray()
        );
    }

    /**
     * @param $tag
     * @return bool
     */
    public function contains($tag): bool
    {
        return in_array(
            new Tag3D($tag),
            $this->toArray()
        );
    }

    /**
     * @param $tag
     * @return Tag3DCollection
     */
    public function append($tag): void
    {
        $tag = new Tag3D($tag);

        if (!$this->contains($tag)) {
            parent::append($tag);
        }
    }

    /**
     * @param $tag
     * @return Tag3DCollection
     */
    public function remove($tag): self
    {
        $tag = new Tag3D($tag);

        foreach ($this as $i => $t) {
            if ($t == $tag) {
                $this->offsetUnset($i);
                continue;
            }
        }

        return $this;
    }

    /**
     * @param $tags
     * @return Tag3DCollection
     */
    public function merge($tags): self
    {
        foreach (new Tag3DCollection($tags) as $t) {
            $this->append($t);
        }

        return $this;
    }

    /**
     * @param string $mask
     * @return Tag3DCollection
     */
    public function match(string $mask): self
    {

        $matched = new Tag3DCollection();

        /** @var Tag3D $tag */

        foreach ($this as $tag) {
            if ($tag->match($mask)) {
                $matched[] = $tag;
            }
        }

        return $matched;
    }

    /**
     * @return Tag3DCollection
     */
    public function empty(): self
    {
        $this->exchangeArray([]);

        return $this;
    }

    /**
     * @param string $mask
     * @return Tag3DCollection
     */
    public function removeFromMatch(string $mask): self
    {
        $new = [];

        /** @var Tag3D $tag */

        foreach ($this as $tag) {
            if (! $tag->match($mask)) {
                $new[] = $tag;
            }
        }

        $this->exchangeArray($new);

        return $this;
    }
}
