<?php

namespace Allocine\DbzModelBundle\Common\Helper;

use PommProject\Foundation\Session\Connection;

class OrderHelper
{
    public static function buildFixedOrder(Connection $connection, string $column, array $values): ?string
    {
        if (empty($values)) {
            return null;
        }

        $query = 'WHEN %s THEN %d';
        $count = 0;

        $cases = array_map(function ($value) use (&$count, $query, $connection) {
            return sprintf($query, $connection->escapeLiteral($value), $count++);
        }, $values);

        return sprintf('CASE %s %s END', $column, implode(' ', $cases));
    }
}
