<?php

namespace Allocine\DbzModelBundle\Tests\Model;

use Allocine\DbzModelBundle\DependencyInjection\ServiceHelper;
use Allocine\DbzModelBundle\Model\Movie\MovieModel;
use Allocine\DbzModelBundle\Tests\KernelTestCase;
use PommProject\ModelManager\Model\Model;

class MasterSlaveTest extends KernelTestCase
{
    /**
     * Check if a slave model use the slave session and the master model the master one.
     * Also tests that underlying connexions (master/slave) are not altered and expected models/connexions are pulled
     * from POMM ContainerModelPooler.
     */
    public function testSlaveModel()
    {
        $kernel = static::bootKernel();

        /** @var MovieModel $slaveMovieModel1 */
        $slaveMovieModel1 = $kernel->getContainer()->get('test.multiple_backend')[0];
        $this->assertSameSessionName(ServiceHelper::BACKEND_SLAVE, $slaveMovieModel1);

        /** @var MovieModel $masterModel */
        $masterModel = $kernel->getContainer()->get('test.testable_services')[0];
        $this->assertSameSessionName(ServiceHelper::BACKEND_MASTER, $masterModel);

        /** @var MovieModel $masterMovieModel1 */
        $masterMovieModel1 = $kernel->getContainer()->get('test.fake_service_with_alias')->getModel();
        $this->assertSameSessionName(ServiceHelper::BACKEND_MASTER, $masterMovieModel1);

        /** @var MovieModel $slaveMovieModel2 */
        $slaveMovieModel2 = $kernel->getContainer()->get('test.multiple_backend')[0];
        $this->assertSameSessionName(ServiceHelper::BACKEND_SLAVE, $slaveMovieModel2);

        /** @var MovieModel $masterMovieModel2 */
        $masterMovieModel2 = $kernel->getContainer()->get('test.multiple_backend')[1];
        $this->assertSameSessionName(ServiceHelper::BACKEND_MASTER, $masterMovieModel2);
    }

    private function assertSameSessionName(string $expected, Model $model)
    {
        return $this->assertSame($expected, $model->getSession()->getStamp());
    }
}
