<?php

namespace Allocine\DbzModelBundle\Internal\Converter;

use PommProject\Foundation\Converter\PgLtree;
use PommProject\Foundation\Session\Session;

class Tag3D extends PgLtree
{
    /**
     * @param string  $data
     * @param string  $type
     * @param Session $session
     *
     * @return array[]|false|mixed|null|string[]``
     */
    public function fromPg($data, $type, Session $session)
    {
        $data = trim($data);

        if ($data === '') {
            return null;
        }

        $explodedLtree = preg_split('/\./', $data);

        if (count($explodedLtree) != 3) {
            throw new \RuntimeException(sprintf(
                'Invalid tag3d [%s]',
                $data
            ));
        }

        return $explodedLtree;
    }
}
