<?php

namespace Allocine\DbzModelBundle\Tests\Type\Brand\Company;

use Allocine\DbzModelBundle\Internal\Type\Brand\Company\Data;
use Allocine\DbzModelBundle\Tests\KernelTestCase;

class DataTest extends KernelTestCase
{
    public function testConstruct()
    {
        // Create a company data with no field

        $companyData = new Data('{}');

        $this->assertNull($companyData->founded_at);
        $this->assertNull($companyData->info->email);
        $this->assertNull($companyData->info->phone);
        $this->assertNull($companyData->info->url);
        $this->assertNull($companyData->links->facebook);
        $this->assertNull($companyData->links->instagram);
        $this->assertNull($companyData->links->linkedin);
        $this->assertNull($companyData->links->pinterest);
        $this->assertNull($companyData->links->snapchat);
        $this->assertNull($companyData->links->tiktok);
        $this->assertNull($companyData->links->tumblr);
        $this->assertNull($companyData->links->twitter);
        $this->assertNull($companyData->links->vk);
        $this->assertNull($companyData->links->wechat);
        $this->assertNull($companyData->links->youtube);
        $this->assertTrue($companyData->seo->browsable);
        $this->assertNull($companyData->seo->title);
        $this->assertNull($companyData->seo->alternate_title);
        $this->assertNull($companyData->seo->description);

        // Create an object with a lot of data

        $companyData = new Data([
            'founded_at' => '1970-01-01',
            'info' => [
                'email' => 'E1',
                'phone' => 'P1',
                'url' => 'U1',
            ], 'links' => [
                'facebook' => 'L1',
                'instagram' => 'L2',
                'linkedin' => 'L3',
                'pinterest' => 'L4',
                'snapchat' => 'L5',
                'tiktok' => 'L6',
                'tumblr' => 'L7',
                'twitter' => 'L8',
                'vk' => 'L9',
                'wechat' => 'L10',
                'youtube' => 'L11',
            ], 'seo' => [
                'browsable' => false,
                'title' => 'T1',
                'alternate_title' => 'T2',
                'description' => 'D1',
            ],
        ]);

        $this->assertEquals(
            new \DateTime('1970-01-01'),
            $companyData->founded_at
        );
        $this->assertEquals('E1', $companyData->info->email);
        $this->assertEquals('P1', $companyData->info->phone);
        $this->assertEquals('U1', $companyData->info->url);
        $this->assertEquals('L1', $companyData->links->facebook);
        $this->assertEquals('L2', $companyData->links->instagram);
        $this->assertEquals('L3', $companyData->links->linkedin);
        $this->assertEquals('L4', $companyData->links->pinterest);
        $this->assertEquals('L5', $companyData->links->snapchat);
        $this->assertEquals('L6', $companyData->links->tiktok);
        $this->assertEquals('L7', $companyData->links->tumblr);
        $this->assertEquals('L8', $companyData->links->twitter);
        $this->assertEquals('L9', $companyData->links->vk);
        $this->assertEquals('L10', $companyData->links->wechat);
        $this->assertEquals('L11', $companyData->links->youtube);
        $this->assertFalse($companyData->seo->browsable);
        $this->assertEquals('T1', $companyData->seo->title);
        $this->assertEquals('T2', $companyData->seo->alternate_title);
        $this->assertEquals('D1', $companyData->seo->description);
    }
}
