<?php

namespace Allocine\DbzModelBundle\Tests\Model\Theater;

use Allocine\DbzModelBundle\Model\Theater\TheaterLocalizedModel;
use Allocine\DbzModelBundle\Tests\KernelTestCase;

class TheaterLocalizedTest extends KernelTestCase
{
    /**
     * @var TheaterLocalizedModel
     */
    private $model;

    /**
     * Setup before
     */
    protected function setUp(): void
    {
        parent::setUp();

        $this->model = $this
            ->getSession()
            ->getModel(TheaterLocalizedModel::class);
    }

    /**
     * Test non-empty data insert
     */
    public function testEmptyData()
    {
        $this->expectException('\Exception');
        $this->expectExceptionMessage(
            'Invalid attribute [coin] for constrained object [Allocine\DbzModelBundle\Internal\Type\Generic\EmptyData]'
        );

        /**
         * Creating a TheaterLocalized
         */

        $theaterLocalized = $this->model->createEntity([
            'code' => 'AAAAA',
            'name' => 'TheaterLocalized 1',
            'locale' => 'fr_FR',
            'data' => [ 'coin' => 'PAN' ]
        ]);

        $this->model->insertOne($theaterLocalized);
    }
}
