<?php

namespace Allocine\DbzModelBundle\Tests;

use Allocine\DbzModelBundle\Tests\App\TestKernel;
use PommProject\Foundation\Exception\FoundationException;
use PommProject\Foundation\Pomm;
use PommProject\Foundation\Session;
use Symfony\Bundle\FrameworkBundle\Test\KernelTestCase as BaseKernelTestCase;

class KernelTestCase extends BaseKernelTestCase
{
    const DBZ_MASTER_SESSION_NAME = 'master';
    const DBZ_SLAVE_SESSION_NAME = 'slave';

    protected static $container;

    protected static function getSessionsName()
    {
        return [
            static::DBZ_MASTER_SESSION_NAME,
            static::DBZ_SLAVE_SESSION_NAME,
        ];
    }

    public static function setUpBeforeClass(): void
    {
        parent::setUpBeforeClass();

    }

    /**
     * Encapsulates every tests within a begin/rollback query so database is not fucked after every test.
     *
     * If you need to test transaction behavior, then you'll need to reimplement setUp() and tearDown().
     */
    protected function setUp(): void
    {
        parent::setUp();

        static::bootKernel();

        /* @var SessionBuilder $builder */
        foreach (static::getSessionsName() as $stamp) {
            $this->getSession($stamp)->getConnection()->executeAnonymousQuery('begin');
        }

        // Insert fixtures if available

        $potentialFixtureFile = __DIR__ . '/Fixtures' . str_replace(
            '\\',
            '/',
            preg_replace(
                '/^.*?\Tests/',
                '',
                static::class
            )
        ) . '/' . $this->getName() . '.sql';

        if (file_exists($potentialFixtureFile)) {
            $this
                ->getSession(self::DBZ_MASTER_SESSION_NAME)
                ->getConnection()
                ->executeAnonymousQuery(file_get_contents(
                    $potentialFixtureFile
                ));
        }
    }

    protected function tearDown(): void
    {
        /* @var SessionBuilder $builder */
        foreach (static::getSessionsName() as $stamp) {
            $this->getSession($stamp)->getConnection()->executeAnonymousQuery('rollback');
        }
    }

    /**
     * Returns a Pomm\Session, the default one if $name = null.
     *
     * @param null $name
     *
     * @return Session\Session
     */
    protected function getSession($name = null)
    {
        $pomm = $this->getPomm();

        try {
            return $name ? $pomm->getSession($name) : $pomm->getDefaultSession();
        } catch (FoundationException $e) {
            $this->fail($e->getMessage());
        }
    }

    /**
     * @return Pomm
     */
    protected function getPomm()
    {
        return static::$container->get('pomm');
    }

    /**
     * {@inheritdoc}
     */
    protected static function getKernelClass()
    {
        return TestKernel::class;
    }

    /**
     * {@inheritdoc}
     */
    protected static function createKernel(array $options = [])
    {
        if (null === static::$class) {
            static::$class = static::getKernelClass();
        }
        $options['test_case'] = isset($options['test_case']) ? $options['test_case'] : null;
        $env = isset($options['environment']) ? $options['environment'] : 'test'.strtolower($options['test_case']);
        $debug = isset($options['debug']) ? $options['debug'] : true;

        return new static::$class($env, $debug, $options['test_case']);
    }
}
