<?php

namespace Allocine\DbzModelBundle\Model\Secure;

use Allocine\DbzModelBundle\Internal\Model\ElementModel;
use Allocine\DbzModelBundle\Model\Secure\AutoStructure\User as UserStructure;

class UserModel extends ElementModel
{
    public function __construct()
    {
        $this->structure = new UserStructure();
        $this->flexible_entity_class = User::class;
    }

    /**
     * @param int $id
     * @return array
     * @throws \PommProject\ModelManager\Exception\ModelException
     */
    public function getPermissions(int $id): array
    {
        $sql = <<<'SQL'
            SELECT unnest(ARRAY[
                universe::TEXT || '.brand.' || b.id,
                universe::TEXT || '.locale.' || b.locale,
                universe::TEXT || '.country.' || b.id_country
            ]) AS permission
            FROM secure.user_has_preset_for_team uhpft
            INNER JOIN secure.preset p
                ON p.id = uhpft.id_preset
            INNER JOIN secure.team t
                ON t.id = uhpft.id_team
            INNER JOIN secure.team_has_brand thb
                ON t.id = thb.id_team
            INNER JOIN brand.brand b
                ON thb.id_brand = b.id
            CROSS JOIN LATERAL unnest(universes) AS universe
            WHERE id_user = $*

            UNION

            SELECT universe::TEXT || '.locale.' || thl.id_locale
            FROM secure.user_has_preset_for_team uhpft
            INNER JOIN secure.preset p
                ON p.id = uhpft.id_preset
            INNER JOIN secure.team t
                ON t.id = uhpft.id_team
            INNER JOIN secure.team_has_locale thl
                ON t.id = thl.id_team
            CROSS JOIN LATERAL unnest(universes) AS universe
            WHERE id_user = $*

            UNION

            SELECT universe::TEXT || '.country.' || thc.id_country
            FROM secure.user_has_preset_for_team uhpft
            INNER JOIN secure.preset p
                ON p.id = uhpft.id_preset
            INNER JOIN secure.team t
                ON t.id = uhpft.id_team
            INNER JOIN secure.team_has_country thc
                ON t.id = thc.id_team
            CROSS JOIN LATERAL unnest(universes) AS universe
            WHERE id_user = $*

            ORDER BY 1
SQL;

        $result = $this
            ->getSession()
            ->getQueryManager()
            ->query($sql, [$id, $id, $id]);

        return array_column(iterator_to_array($result), 'permission');
    }
}
