<?php

namespace Allocine\DbzModelBundle\Model\Brand;

use Allocine\DbzModelBundle\Internal\Model\BrandAwareModelInterface;
use Allocine\DbzModelBundle\Internal\Model\BrandAwareModelTrait;
use Allocine\DbzModelBundle\Internal\Model\ModelTrait;
use Allocine\DbzModelBundle\Model\Brand\AutoStructure\Movie as MovieStructure;
use PommProject\ModelManager\Model\Model;
use PommProject\ModelManager\Model\ModelTrait\ReadQueries;

/**
 * MovieModel.
 *
 * Model class for table movie.
 *
 * @see Model
 */
class MovieModel extends Model implements BrandAwareModelInterface
{
    use ReadQueries;
    use ModelTrait;
    use BrandAwareModelTrait;

    /**
     * __construct().
     *
     * Model constructor
     */
    public function __construct()
    {
        $this->structure = new MovieStructure();
        $this->flexible_entity_class = '\Allocine\DbzModelBundle\Model\Brand\Movie';
    }
}
