<?php

namespace Allocine\DbzModelBundle\Model\Brand;

use Allocine\DbzModelBundle\Internal\Model\BrandAwareModelInterface;
use Allocine\DbzModelBundle\Internal\Model\BrandAwareModelTrait;
use Allocine\DbzModelBundle\Internal\Model\ModelTrait;
use Allocine\DbzModelBundle\Model\Brand\AutoStructure\MovieHasCompany as MovieHasCompanyStructure;
use PommProject\ModelManager\Model\Model;
use PommProject\ModelManager\Model\ModelTrait\ReadQueries;

/**
 * MovieHasCompanyModel.
 *
 * Model class for table movie_has_company.
 *
 * @see Model
 */
class MovieHasCompanyModel extends Model implements BrandAwareModelInterface
{
    use ReadQueries;
    use ModelTrait;
    use BrandAwareModelTrait;

    /**
     * __construct().
     *
     * Model constructor
     */
    public function __construct()
    {
        $this->structure = new MovieHasCompanyStructure();
        $this->flexible_entity_class = MovieHasCompany::class;
    }
}
